/*******************************************************************************

   Copyright (c) Hilscher GmbH. All Rights Reserved.

 *******************************************************************************

   Last Modification:
    @version $Id: S3M_ACFG_Public.h 61019 2016-05-04 09:40:56Z Sven $

   Changes:

     Version    Date        Author   Description
     ---------------------------------------------------------------------------
    1           2012-07-25  sb      created
*******************************************************************************/

#ifndef S3M_ACFG_PUBLIC_H_INCLUDED
#define S3M_ACFG_PUBLIC_H_INCLUDED

/***************************************************************************************/
/* SIII MA ACFG public, constants */

#define SIII_MA_ACFG_PROCESS_QUEUE_NAME       "QUE_S3M_ACFG"


#define SIII_MA_ACFG_CMD_AUTO_CONFIGURE_REQ               0x8A00
#define SIII_MA_ACFG_CMD_AUTO_CONFIGURE_CNF               0x8A01

#define SIII_MA_ACFG_CMD_READ_ERROR_STATUS_REQ            0x8A02
#define SIII_MA_ACFG_CMD_READ_ERROR_STATUS_CNF            0x8A03

/* pragma pack */
#ifdef PRAGMA_PACK_ENABLE
#pragma PRAGMA_PACK_1(SIII_MA_ACFG_PUBLIC)
#endif

/******************************************************************************/
typedef __TLR_PACKED_PRE struct SIII_MA_ACFG_READ_ERROR_STATUS_ENTRY_Ttag
{
  TLR_UINT16 usTopologyAddress;
  TLR_UINT16 usSercosAddress;
  TLR_UINT16 usErrorReason;
} __TLR_PACKED_POST SIII_MA_ACFG_READ_ERROR_STATUS_ENTRY_T;

enum
{
  SIII_MA_ACFG_ERROR_REASON_NONE = 0, /* not used in packet */
  SIII_MA_ACFG_ERROR_REASON_UNKNOWN_CONFIG_TYPE = 1,
  SIII_MA_ACFG_ERROR_REASON_UNSUPPORTED_PROFILE_DETECTED = 2,
  SIII_MA_ACFG_ERROR_REASON_UNSUPPORTED_PROFILE_TYPE_CFG_TYPE_COMBINATION_DETECTED = 3,
  SIII_MA_ACFG_ERROR_REASON_DID_NOT_ACCEPT_OUR_CONNECTION_PARAMETERS = 4,
  SIII_MA_ACFG_ERROR_REASON_IGNORED_SVC_ERROR = 5,
  SIII_MA_ACFG_ERROR_REASON_INVALID_UNCHANGEABLE_SERCOS_ADDRESS = 6,
  SIII_MA_ACFG_ERROR_REASON_DUPLICATE_UNCHANGEABLE_SERCOS_ADDRESS = 7,
  SIII_MA_ACFG_ERROR_REASON_ASSIGNING_SERCOS_ADDRESS_DENIED_BY_MIN_MAX = 8,
  SIII_MA_ACFG_ERROR_REASON_ASSIGNING_SERCOS_ADDRESS_DENIED_WHEN_WRITING = 9,
  SIII_MA_ACFG_ERROR_REASON_SVC_ACCESS_ERROR = 10,
  SIII_MA_ACFG_ERROR_REASON_BUS_SCAN_INFO_ACCESS_ERROR = 11,
  SIII_MA_ACFG_ERROR_REASON_OUT_OF_MEMORY = 12,
};


/******************************************************************************
 * Packet:  SIII_MA_ACFG_CMD_AUTO_CONFIGURE_REQ/SIII_MA_ACFG_CMD_AUTO_CONFIGURE_CNF
 */

typedef __TLR_PACKED_PRE struct SIII_MA_ACFG_AUTO_CONFIGURE_REQ_DATA_APTASK_Ttag
{
  /** reserved for IO status */
  TLR_UINT32                                    ulSystemFlags;
  /** watchdog time in millisecs */
  TLR_UINT32                                    ulWatchdogTime;

  /* Stack configuration flags */
  TLR_UINT32                                    ulStackCfgFlags;

  /* Frames Lost threshold */
  TLR_UINT32                                    ulFramesLostThreshold;

  /* Threshold for bus-synchronous modes */
  TLR_UINT32                                    ulBusSynchronousThreshold;

  TLR_UINT32                                    ulBusSynchronousInputThreshold;

  TLR_UINT32                                    ulBusSynchronousOutputThreshold;
} __TLR_PACKED_POST SIII_MA_ACFG_AUTO_CONFIGURE_REQ_DATA_APTASK_T;

/* request packet */
typedef __TLR_PACKED_PRE struct SIII_MA_ACFG_AUTO_CONFIGURE_REQ_DATA_Ttag
{
  TLR_UINT32                                    ulCommunicationCycleTime;
  TLR_UINT32                                    ulCommunicationTimeoutCP3_4;
  TLR_UINT32                                    ulCommandValueValidTime;
  TLR_UINT32                                    ulATTransmissionStartingTime;
  TLR_UINT32                                    ulTransmissionTime_t6;
  TLR_UINT32                                    ulTransmissionTime_t7;
  TLR_UINT32                                    ulSynchronizationTime;
  TLR_UINT32                                    ulSyncJitter;
  TLR_UINT16                                    usNRTChannelMTU;
  TLR_UINT32                                    ulProcessDataOutputSize;
  TLR_UINT32                                    ulProcessDataInputSize;
  TLR_UINT32                                    ulCP0_CycleWait_For_StableState;
  TLR_UINT32                                    ulStackConfigurationFlags;
  SIII_MA_ACFG_AUTO_CONFIGURE_REQ_DATA_APTASK_T tAPParam;
  TLR_UINT32                                    ulACFGFlags;
  /* S-0-1061 Maximum TSref Counter (valid values between 0 and 16383) */
  TLR_UINT32                                    ulMaximumTsRefCounter;
  /* communication cycle time for CP1/CP2 (valid when MSK_SIII_MA_CP_ENABLE_CP1_CP2_PARAMETERS_OPTION is set) */
  TLR_UINT32                                    ulCP1_CP2_CommunicationCycleTime;
  /* AT transmission starting time for CP1/CP2 (valid when MSK_SIII_MA_CP_ENABLE_CP1_CP2_PARAMETERS_OPTION is set) */
  TLR_UINT32                                    ulCP1_CP2_ATTransmissionStartingTime;
  /* NRT transmission time (t6) for CP1/CP2 (valid when MSK_SIII_MA_CP_ENABLE_CP1_CP2_PARAMETERS_OPTION is set) */
  TLR_UINT32                                    ulCP1_CP2_TransmissionTime_t6;
  /* NRT transmission time (t7) for CP1/CP2 (valid when MSK_SIII_MA_CP_ENABLE_CP1_CP2_PARAMETERS_OPTION is set) */
  TLR_UINT32                                    ulCP1_CP2_TransmissionTime_t7;
  /* following three fields only valid when MSK_SIII_MA_ACFG_AUTO_CONFIGURE_FLAGS_CONFIGURE_SCP_NRT is set */
  TLR_UINT8                                     abMasterIPAddress[4];
  TLR_UINT8                                     abSubnetMask[4];
  TLR_UINT8                                     abGatewayAddress[4];
} __TLR_PACKED_POST SIII_MA_ACFG_AUTO_CONFIGURE_REQ_DATA_T;

typedef __TLR_PACKED_PRE struct SIII_MA_ACFG_AUTO_CONFIGURE_REQ_Ttag
{
  TLR_PACKET_HEADER_T                           tHead;
  SIII_MA_ACFG_AUTO_CONFIGURE_REQ_DATA_T        tData;
} __TLR_PACKED_POST SIII_MA_ACFG_AUTO_CONFIGURE_REQ_T;

enum SIII_MA_ACFG_AUTO_CONFIGURE_FLAGS_Etag
{
  MSK_SIII_MA_ACFG_AUTO_CONFIGURE_FLAGS_SET_HP_SLAVES_AS_OPTIONAL     = 0x00000001,
  MSK_SIII_MA_ACFG_AUTO_CONFIGURE_FLAGS_CHECK_VENDOR_CODE_ON_BOOTUP   = 0x00000002,
  MSK_SIII_MA_ACFG_AUTO_CONFIGURE_FLAGS_CHECK_DEVICE_ID_ON_BOOTUP     = 0x00000004,
  MSK_SIII_MA_ACFG_AUTO_CONFIGURE_FLAGS_USE_FG_IN_FSP_IO              = 0x00000008,
  MSK_SIII_MA_ACFG_AUTO_CONFIGURE_FLAGS_USE_AT_MDT_FOR_VARCFG         = 0x00000010,
  MSK_SIII_MA_ACFG_AUTO_CONFIGURE_FLAGS_CONFIGURE_SCP_NRT             = 0x00000020,
  MSK_SIII_MA_ACFG_AUTO_CONFIGURE_FLAGS_USE_TOPOLOGY_ADDRESSING       = 0x00000040,
};

/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_MA_ACFG_AUTO_CONFIGURE_CNF_DATA_Ttag
{
  SIII_MA_ACFG_READ_ERROR_STATUS_ENTRY_T        atEntries[511];  /* actual amount depends on ulLen */
} __TLR_PACKED_POST SIII_MA_ACFG_AUTO_CONFIGURE_CNF_DATA_T;

typedef __TLR_PACKED_PRE struct SIII_MA_ACFG_AUTO_CONFIGURE_CNF_Ttag
{
  TLR_PACKET_HEADER_T                           tHead;
  SIII_MA_ACFG_AUTO_CONFIGURE_CNF_DATA_T        tData;
} __TLR_PACKED_POST SIII_MA_ACFG_AUTO_CONFIGURE_CNF_T;

/* packet union */
typedef union SIII_MA_ACFG_AUTO_CONFIGURE_PCK_Ttag
{
  TLR_PACKET_HEADER_T                           tHead;
  SIII_MA_ACFG_AUTO_CONFIGURE_REQ_T             tReq;
  SIII_MA_ACFG_AUTO_CONFIGURE_CNF_T             tCnf;
} SIII_MA_ACFG_AUTO_CONFIGURE_PCK_T;

/******************************************************************************
 * Packet:  SIII_MA_ACFG_CMD_READ_ERROR_STATUS_REQ/SIII_MA_ACFG_CMD_READ_ERROR_STATUS_CNF
 */

/* request packet */
typedef __TLR_PACKED_PRE struct SIII_MA_ACFG_READ_ERROR_STATUS_REQ_Ttag
{
  TLR_PACKET_HEADER_T                           tHead;
} __TLR_PACKED_POST SIII_MA_ACFG_READ_ERROR_STATUS_REQ_T;


/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_MA_ACFG_READ_ERROR_STATUS_CNF_DATA_Ttag
{
  SIII_MA_ACFG_READ_ERROR_STATUS_ENTRY_T        atEntries[511];  /* actual amount depends on ulLen */
} __TLR_PACKED_POST SIII_MA_ACFG_READ_ERROR_STATUS_CNF_DATA_T;

typedef __TLR_PACKED_PRE struct SIII_MA_ACFG_READ_ERROR_STATUS_CNF_Ttag
{
  TLR_PACKET_HEADER_T                           tHead;
  SIII_MA_ACFG_READ_ERROR_STATUS_CNF_DATA_T     tData;
} __TLR_PACKED_POST SIII_MA_ACFG_READ_ERROR_STATUS_CNF_T;

/* packet union */
typedef union SIII_MA_ACFG_READ_ERROR_STATUS_PCK_Ttag
{
  TLR_PACKET_HEADER_T                           tHead;
  SIII_MA_ACFG_READ_ERROR_STATUS_REQ_T          tReq;
  SIII_MA_ACFG_READ_ERROR_STATUS_CNF_T          tCnf;
} SIII_MA_ACFG_READ_ERROR_STATUS_PCK_T;

/* pragma pack */
#ifdef PRAGMA_PACK_ENABLE
#pragma PRAGMA_UNPACK_1(SIII_MA_ACFG_PUBLIC)
#endif

#endif // S3M_ACFG_PUBLIC_H_INCLUDED
